function monthly_variation(Hs_vec,Te_vec,DirP_vec,Data,dHs,dTe,plot_flag)
%% input
% -----> Hs_vec vector containing all years Hs   
% -----> Te_vec vector containing all years Te   
% -----> Data time series data

month_names = {'January','February','March','April','May','June','July','August','September','October','November','December'};

% clearvars -except Data Hs_vec Te_vec DirP_vec dHs dTe month_names

table = timetable(Data,Hs_vec,Te_vec,DirP_vec);

results = struct();

%% data

time  = 1:length(Hs_vec); % time stamps
Temax = ceil(max(Te_vec));
Hsmax = ceil(max(Hs_vec));

% Creating Bin
nBinHs = (Hsmax/dHs)+1;
nBinTe = (Temax/dTe)+1;
Hs_bin = linspace(0,Hsmax,nBinHs);% min(Hs), max(Hs), bin number
Te_bin = linspace(0,Temax,nBinTe);% min(Tp), max(Tp), bin number
Ntot   = length(time);
Hs_mat = repmat(Hs_bin',1,nBinTe);
Te_mat = repmat(Te_bin,nBinHs,1);

for ii=1:12

    results(ii).monthly = table(ismember(month(table.Data),ii),:);

    [scatter(ii)] = scatter_output(results(ii).monthly.Hs_vec,results(ii).monthly.Te_vec,results(ii).monthly.DirP_vec,Hs_bin,Te_bin,Ntot);
    days = length(results(ii).monthly.Hs_vec)/24/4;
    
    if plot_flag ==1
    
    figure()
    subplot(2,1,1)
    surface(Te_mat,Hs_mat,scatter(ii).occ)
    title([[string(month_names{ii})];['Occ = ',num2str(sum(sum(scatter(ii).occ)))]])
    ylim([0 Hsmax])
    xlim([0 Temax])
    xlabel('$T_e$ [s]')
    ylabel('$H_s$ [m]')
    
    
    
    subplot(2,1,2)
    surface(Te_mat,Hs_mat,scatter(ii).energy)
    title(['Energy = ',num2str(sum(sum(scatter(ii).energy))/24/days),'  [kW/m]'])
    ylim([0 Hsmax])
    xlim([0 Temax])
    xlabel('$T_e$ [s]')
    ylabel('$H_s$ [m]')
    
    end
    
    
    mean_en(ii) = sum(sum(scatter(ii).energy))/24/days;
end

disp('----------------------------------------------------------------')
disp(['mean energy among considered months = ',num2str(mean(mean_en)),'  [kW/m]']);
disp('----------------------------------------------------------------')

end

